clear all;
close all; 
clc;

cd('MixIMStimuli')

IMG = cell(4,3);P_G = cell(4,3);BW_R = cell(4,3);BW_G = cell(4,3);BW_B = cell(4,3);
img_substrat = cell(12,12);

thresholdLevel = 0.03; % between (0,1)
thresholdLevel = thresholdLevel * 171123 / 488448; % without black backgroud
posterize_level=[255 5 255]; % for now showing G channel only, level = 4 (5 = 4 + 1, including black)
cnt=0;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for light = 1:3
    % Original image

    for mat = 1:4
        IM_name = sprintf('Stimulus-%d-%d.jpg',mat,light);
        I0 = imread(IM_name);
        I = hue_trans_FZ(I0,0.33);
        IMG{mat,light} = I;
        
        redChannel = I(:, :, 1);
        greenChannel = I(:, :, 2);
        blueChannel = I(:, :, 3);
        [red_sorted ind_red_sorted]= sort(redChannel(:), 'descend');
%         [green_sorted ind_green_sorted]= sort(greenChannel(:), 'descend');
%         [blue_sorted ind_blue_sorted]= sort(blueChannel(:))
        Mx = max(max(max(I)));
%         threshold = thresholdLevel * Mx;
        threshold = red_sorted(round(size(red_sorted,1)*thresholdLevel)); %threshold_index = size(red_sorted,1)*thresholdLevel);
        BW_R{mat,light} = redChannel  > threshold;
        BW_G{mat,light} = greenChannel  > threshold;
        BW_B{mat,light} = blueChannel  > threshold;
        
        I_gray = rgb2gray(I);
        [gray_sorted ind_gray_sorted]= sort(I_gray(:), 'descend');
        threshold = gray_sorted(round(size(gray_sorted,1)*thresholdLevel));
        BW_gray{mat,light} = I_gray  > threshold;
        %%%%%%%%%%%%%%%%%%%%%% posterize %%%%%%%%%%%%%%%%%%%%%%%%%%

        I=double(I);
    %     posterize_level=[255 6 255]; %G channel only, level:6
        for i = 1:512
            for j = 1:954
                for k = 2 % G channel only
                    
                I(i,j,k)=round(I(i,j,k)*255*posterize_level(k)/255)*255/posterize_level(k);
                end
            end
        end

        P_G{mat,light} = uint8(I(:,:,2));


          cnt=cnt+1; figure(1),maxsubplot(3,4,13-cnt),

%           if mat == 1
          imshow(P_G{mat,light});
          
          
          
        %%%%%%%%%%%%%%%%%%%%%% thresholding %%%%%%%%%%%%%%%%%%%%%%%%%%          
figure(2),maxsubplot(3,4,13-cnt),%           else
          imshow(BW_gray{mat,light}); % luminance thresholding
%           imshow(BW_R{mat,light}); % red channel thresholding
          title(['threshold level ' sprintf('%.2f%%',threshold.*100)]);set(gca,'FontSize',13);
figure(3),maxsubplot(3,4,13-cnt),%           else
% %           Inew = I_gray.*BW_gray{mat,light};
%           Inew(:,:,1) = I0(:,:,1).*BW_gray{mat,light};
%           Inew(:,:,2) = I0(:,:,2).*BW_gray{mat,light};
%           Inew(:,:,3) = I0(:,:,3).*BW_gray{mat,light};
          imshow(bsxfun(@times, IMG{mat,light}, cast(BW_gray{mat,light}, 'like', IMG{mat,light})));
        %%%%%%%%%%%%%%%%%%%%%% histogram %%%%%%%%%%%%%%%%%%%%%%%%%%
I3 = rgb2gray(IMG{mat,light});
figure(4), subplot(3,4,cnt),imhist(I3);
 
 axis([0,1,0,10000]);
 set(gca,'XTick',[0:0.2:1],'YTick',10000.*[0:0.25:1],'FontSize',14);
% 
%         %%%%%%%%%%%%%%%%%%%%%% original img %%%%%%%%%%%%%%%%%%%%%%%%%%
% figure(4), subplot(3,4,cnt),imshow(IMG{mat,light});
% 
          %%%%%%%%%%%%%%%%%%%%%% bird shape mask %%%%%%%%%%%%%%%%%%%%%%%%%%
if cnt == 1
    mask= find(greenChannel(:)>0);    
end
        
    end
    
end


