clear all; close all; clc;
IMG = cell(1,4);P_G = cell(1,4);BW_R = cell(1,4);BW_G = cell(1,4);BW_B = cell(1,4);

thresholdLevel = 0.75; % between (0,1)
posterize_level=[255 6 255]; % for now showing G channel only, level = 6
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for exp = 1:2
    % Original image
    IMG{1} = imread(['M_Exp' num2str(exp) '.jpg']);
    IMG{2} = imread(['V_Exp' num2str(exp) '.jpg']);
    IMG{3} = imread(['S_Exp' num2str(exp) '.jpg']);
    IMG{4} = imread(['G_Exp' num2str(exp) '.jpg']);
    
%     for t = 1:4
%         IMG{t} = hue_trans_FZ(IMG{t},0.33);
%     end
    
    for t = 1:4
        I = IMG{t};
        %%%%%%%%%%%%%%%%% thresholding %%%%%%%%%%%%%%%%%%%%%
        redChannel = I(:, :, 1);
        greenChannel = I(:, :, 2);
        blueChannel = I(:, :, 3);

        threshold = thresholdLevel * 255;
        BW_R{t} = redChannel  > threshold;
        BW_G{t} = greenChannel  > threshold;
        BW_B{t} = blueChannel  > threshold;


        %%%%%%%%%%%%%%%%%%%%%% posterize %%%%%%%%%%%%%%%%%%%%%%%%%%

        I=double(I);
    %     posterize_level=[255 6 255]; %G channel only, level:6
        for i = 1:512
            for j = 1:954
                for k = 2 % G channel only
                I(i,j,k)=(round(I(i,j,k)/255*posterize_level(k))*255/posterize_level(k));
                end
            end
        end

        P_G{t} = uint8(I);

        %%%%%%%%%%%%%%%%%%%%%% plot %%%%%%%%%%%%%%%%%%%%%%%%%%
        figure(exp),
        maxsubplot(5,4,21-t),imshow(IMG{t});
        maxsubplot(5,4,17-t),imshow(P_G{t});
        maxsubplot(5,4,13-t),imshow(BW_R{t});
        maxsubplot(5,4,9-t),imshow(BW_G{t});
        maxsubplot(5,4,5-t),imshow(BW_B{t});

    end
end
